class SendMoneySaveResponseModel {
  SendMoneySaveResponseModel({
      String? remark, 
      String? status, 
      Message? message, 
      Data? data,}){
    _remark = remark;
    _status = status;
    _message = message;
    _data = data;
}

  SendMoneySaveResponseModel.fromJson(dynamic json) {
    _remark = json['remark'];
    _status = json['status'].toString();
    _message = json['message'] != null ? Message.fromJson(json['message']) : null;
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _remark;
  String? _status;
  Message? _message;
  Data? _data;

  String? get remark => _remark;
  String? get status => _status;
  Message? get message => _message;
  Data? get data => _data;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['remark'] = _remark;
    map['status'] = _status;
    if (_message != null) {
      map['message'] = _message?.toJson();
    }
    if (_data != null) {
      map['data'] = _data?.toJson();
    }
    return map;
  }

}

class Data {
  Data({
      String? paymentType, 
      SendMoney? sendMoney,}){
    _paymentType = paymentType;
    _sendMoney = sendMoney;
}

  Data.fromJson(dynamic json) {
    _paymentType = json['payment_type'] != null ? json['payment_type'].toString() : '';
    _sendMoney = json['send_money'] != null ? SendMoney.fromJson(json['send_money']) : null;
  }
  String? _paymentType;
  SendMoney? _sendMoney;

  String? get paymentType => _paymentType;
  SendMoney? get sendMoney => _sendMoney;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['payment_type'] = _paymentType;
    if (_sendMoney != null) {
      map['send_money'] = _sendMoney?.toJson();
    }
    return map;
  }

}

class SendMoney {
  SendMoney({
      String? mtcnNumber, 
      String? userId,
      String? serviceId, 
      List<ServiceFormData>? serviceFormData, 
      String? countryDeliveryMethodId,
      String? baseCurrencyAmount,
      String? baseCurrencyCharge,
      String? sendingCountryId,
      String? sendingCurrency, 
      String? sendingAmount, 
      String? sendingCharge,
      String? recipientCountryId,
      String? recipientCurrency, 
      String? recipientAmount,
      String? sourceOfFundId,
      String? sendingPurposeId,
      String? trx, 
      String? conversionRate,
      String? baseCurrencyRate, 
      Sender? sender, 
      Recipient? recipient, 
      String? updatedAt, 
      String? createdAt, 
      int? id,}){
    _mtcnNumber = mtcnNumber;
    _userId = userId;
    _serviceId = serviceId;
    _serviceFormData = serviceFormData;
    _countryDeliveryMethodId = countryDeliveryMethodId;
    _baseCurrencyAmount = baseCurrencyAmount;
    _baseCurrencyCharge = baseCurrencyCharge;
    _sendingCountryId = sendingCountryId;
    _sendingCurrency = sendingCurrency;
    _sendingAmount = sendingAmount;
    _sendingCharge = sendingCharge;
    _recipientCountryId = recipientCountryId;
    _recipientCurrency = recipientCurrency;
    _recipientAmount = recipientAmount;
    _sourceOfFundId = sourceOfFundId;
    _sendingPurposeId = sendingPurposeId;
    _trx = trx;
    _conversionRate = conversionRate;
    _baseCurrencyRate = baseCurrencyRate;
    _sender = sender;
    _recipient = recipient;
    _updatedAt = updatedAt;
    _createdAt = createdAt;
    _id = id;
}

  SendMoney.fromJson(dynamic json) {
    _mtcnNumber = json['mtcn_number'].toString();
    _userId = json['user_id'].toString();
    _serviceId = json['service_id'].toString();
    if (json['service_form_data'] != null) {
      _serviceFormData = [];
      json['service_form_data'].forEach((v) {
        _serviceFormData?.add(ServiceFormData.fromJson(v));
      });
    }
    _countryDeliveryMethodId = json['country_delivery_method_id'].toString();
    // _baseCurrencyAmount = json['base_currency_amount'];
    _baseCurrencyAmount = json['base_currency_amount'] != null? json['base_currency_amount'].toString() :  "";

    _baseCurrencyCharge = json['base_currency_charge'] != null? json['base_currency_charge'].toString() :  "";
    _sendingCountryId = json['sending_country_id'] != null? json['sending_country_id'].toString() :  "";
    _sendingCurrency = json['sending_currency'] != null? json['sending_currency'].toString() :  "";
    _sendingAmount = json['sending_amount'] != null? json['sending_amount'].toString() :  "";
    _sendingCharge = json['sending_charge'] != null? json['sending_charge'].toString() :  "";
    _recipientCountryId = json['recipient_country_id'] != null? json['recipient_country_id'].toString() :  "";
    _recipientCurrency = json['recipient_currency'] != null? json['recipient_currency'].toString() :  "";
    _recipientAmount = json['recipient_amount'] != null? json['recipient_amount'].toString() :  "";
    _sourceOfFundId = json['source_of_fund_id'] != null? json['source_of_fund_id'].toString() :  "";
    _sendingPurposeId = json['sending_purpose_id'] != null? json['sending_purpose_id'].toString() :  "";
    _trx = json['trx'];
    _conversionRate = json['conversion_rate'] != null? json['conversion_rate'].toString() :  "";
    _baseCurrencyRate = json['base_currency_rate']  != null? json['base_currency_rate'].toString() :  "";
    _sender = json['sender'] != null ? Sender.fromJson(json['sender']) : null;
    _recipient = json['recipient'] != null ? Recipient.fromJson(json['recipient']) : null;
    _updatedAt = json['updated_at'];
    _createdAt = json['created_at'];
    _id = json['id'];
  }
  String? _mtcnNumber;
  String? _userId;
  String? _serviceId;
  List<ServiceFormData>? _serviceFormData;
  String? _countryDeliveryMethodId;
  String? _baseCurrencyAmount;
  String? _baseCurrencyCharge;
  String? _sendingCountryId;
  String? _sendingCurrency;
  String? _sendingAmount;
  String? _sendingCharge;
  String? _recipientCountryId;
  String? _recipientCurrency;
  String? _recipientAmount;
  String? _sourceOfFundId;
  String? _sendingPurposeId;
  String? _trx;
  String? _conversionRate;
  String? _baseCurrencyRate;
  Sender? _sender;
  Recipient? _recipient;
  String? _updatedAt;
  String? _createdAt;
  int? _id;

  String? get mtcnNumber => _mtcnNumber;
  String? get userId => _userId;
  String? get serviceId => _serviceId;
  List<ServiceFormData>? get serviceFormData => _serviceFormData;
  String? get countryDeliveryMethodId => _countryDeliveryMethodId;
  String? get baseCurrencyAmount => _baseCurrencyAmount;
  String? get baseCurrencyCharge => _baseCurrencyCharge;
  String? get sendingCountryId => _sendingCountryId;
  String? get sendingCurrency => _sendingCurrency;
  String? get sendingAmount => _sendingAmount;
  String? get sendingCharge => _sendingCharge;
  String? get recipientCountryId => _recipientCountryId;
  String? get recipientCurrency => _recipientCurrency;
  String? get recipientAmount => _recipientAmount;
  String? get sourceOfFundId => _sourceOfFundId;
  String? get sendingPurposeId => _sendingPurposeId;
  String? get trx => _trx;
  String? get conversionRate => _conversionRate;
  String? get baseCurrencyRate => _baseCurrencyRate;
  Sender? get sender => _sender;
  Recipient? get recipient => _recipient;
  String? get updatedAt => _updatedAt;
  String? get createdAt => _createdAt;
  int? get id => _id;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['mtcn_number'] = _mtcnNumber;
    map['user_id'] = _userId;
    map['service_id'] = _serviceId;
    if (_serviceFormData != null) {
      map['service_form_data'] = _serviceFormData?.map((v) => v.toJson()).toList();
    }
    map['country_delivery_method_id'] = _countryDeliveryMethodId;
    map['base_currency_amount'] = _baseCurrencyAmount;
    map['base_currency_charge'] = _baseCurrencyCharge;
    map['sending_country_id'] = _sendingCountryId;
    map['sending_currency'] = _sendingCurrency;
    map['sending_amount'] = _sendingAmount;
    map['sending_charge'] = _sendingCharge;
    map['recipient_country_id'] = _recipientCountryId;
    map['recipient_currency'] = _recipientCurrency;
    map['recipient_amount'] = _recipientAmount;
    map['source_of_fund_id'] = _sourceOfFundId;
    map['sending_purpose_id'] = _sendingPurposeId;
    map['trx'] = _trx;
    map['conversion_rate'] = _conversionRate;
    map['base_currency_rate'] = _baseCurrencyRate;
    if (_sender != null) {
      map['sender'] = _sender?.toJson();
    }
    if (_recipient != null) {
      map['recipient'] = _recipient?.toJson();
    }
    map['updated_at'] = _updatedAt;
    map['created_at'] = _createdAt;
    map['id'] = _id;
    return map;
  }

}

class Recipient {
  Recipient({
      String? name, 
      String? mobile, 
      String? email, 
      String? address,}){
    _name = name;
    _mobile = mobile;
    _email = email;
    _address = address;
}

  Recipient.fromJson(dynamic json) {
    _name = json['name'] ?? '';
    _mobile = json['mobile'] ?? '';
    _email = json['email'] ?? '';
    _address = json['address'] ?? '';
  }
  String? _name;
  String? _mobile;
  String? _email;
  String? _address;

  String? get name => _name;
  String? get mobile => _mobile;
  String? get email => _email;
  String? get address => _address;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = _name;
    map['mobile'] = _mobile;
    map['email'] = _email;
    map['address'] = _address;
    return map;
  }

}

class Sender {
  Sender({
      String? mobile, 
      dynamic email, 
      dynamic address,}){
    _mobile = mobile;
    _email = email;
    _address = address;
}

  Sender.fromJson(dynamic json) {
    _mobile = json['mobile'] ?? '';
    _email = json['email'] ?? '';
    _address = json['address'] ?? '';
  }
  String? _mobile;
  dynamic _email;
  dynamic _address;

  String? get mobile => _mobile;
  dynamic get email => _email;
  dynamic get address => _address;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['mobile'] = _mobile;
    map['email'] = _email;
    map['address'] = _address;
    return map;
  }

}

class ServiceFormData {
  ServiceFormData({
      String? name, 
      String? type, 
      String? value,}){
    _name = name;
    _type = type;
    _value = value;
}

  ServiceFormData.fromJson(dynamic json) {
    _name = json['name'] ?? '';
    _type = json['type'] != null ? json['type'].toString() : '';
    _value = json['value'].toString();
  }
  String? _name;
  String? _type;
  String? _value;

  String? get name => _name;
  String? get type => _type;
  String? get value => _value;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = _name;
    map['type'] = _type;
    map['value'] = _value;
    return map;
  }

}

/*
class Message {
  Message({
      List<List<String>>? success,}){
    _success = success;
}

  Message.fromJson(dynamic json) {
    _success = json['success'] != null ? json['success'].cast<String>() : [];
  }

  // Message.fromJson(dynamic json) {
  //   _success = json['success'] != null
  //       ? (json['success'] as List).map((item) => List<String>.from(item)).toList()
  //       : [];
  // }

  List<List<String>>? _success;

  List<List<String>>? get success => _success;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['success'] = _success;
    return map;
  }

}*/
class Message {
  Message({
    List<String>? success,
    List<String>? error
  }){
    _success = success;
    _error = error;
  }

  Message.fromJson(dynamic json) {
    _success = json['success'] != null ? [json['success'].toString()] : null;
    _error   = json['error']   != null ? [json['error'].toString()]  : null;
  }

  List<String>? _success;
  List<String>? _error;

  List<String>? get success => _success;
  List<String>? get error => _error;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['success'] = _success;
    map['error'] = _error;
    return map;
  }

}